const quotes = [
    { quote: "The only way to do great work is to love what you do.", author: "Steve Jobs" },
    { quote: "In the midst of chaos, there is also opportunity.", author: "Sun Tzu" },
    { quote: "Life is not about finding yourself. Life is about creating yourself.", author: "George Bernard Shaw" },
    { quote: "The best revenge is massive success.", author: "Frank Sinatra" },
    { quote: "The greatest glory in living lies not in never falling, but in rising every time we fall.", author: "Nelson Mandela" }
  ];
  
  const quoteContainer = document.getElementById('quote-container');
  const quoteText = document.getElementById('quote');
  const authorText = document.getElementById('author');
  const generateButton = document.getElementById('generate-btn');
  
  generateButton.addEventListener('click', generateQuote);
  
  function generateQuote() {
    const randomIndex = Math.floor(Math.random() * quotes.length);
    const randomQuote = quotes[randomIndex];
    quoteText.textContent = randomQuote.quote;
    authorText.textContent = "- " + randomQuote.author;
  }
  
  // Generate initial quote
  generateQuote();
  